<?
class PAGES
{

	private $db;
	private $form;

	public function __construct ($db, $form)
	{
        $this->db 		= $db;
        $this->form 	= $form;
	}


	public function addPage ($name, $title ,$content, $share)
	{

	      /* Name error checking */
	      $field = "name";
	      if(!$name || strlen($name = trim($name)) == 0)
	      {
	         $this->form->setError($field, $GLOBALS[lang][_pages_addpage_no_name]);
	      }

	      /* Title error checking */
	      $field = "title";
	      if(!$title || strlen($title = trim($title)) == 0)
	      {
	         $this->form->setError($field, $GLOBALS[lang][_pages_addpage_no_title]);
	      }

	      /* Content error checking */
	      $field = "content";
	      if(!$content || strlen($content = trim($content)) == 0)
	      {
	         $this->form->setError($field, $GLOBALS[lang][_pages_addpage_no_content]);
	      }

	      if($this->form->_num_errors > 0)
	      {
	         return false;  //Errors with form
	      }
	      else
	      {

	      	 $content = addslashes(trim($content));

	         if($this->doaddPage($name ,$title ,$content, $share))
	         {
	            return true;
	         }
	         else
	         {
	            return false;
	         }

	      }
 	}


 	private function doaddPage($name ,$title ,$content, $share)
 	{
    	$info = "pages";

    	$array = array(
		    		"id" 			=> NULL,
		    		"name"			=> $name,
		    		"title" 		=> $title,
		    		"content" 		=> $content,
		    		"totalview" 	=> 0,
		    		"allow_share" 	=> $share
		    		);

		$insert = $this->db->insert($info,$array);

		if($insert)
		{
			return(true);
		}
		else
		{
			return(false);
		}
 	}


 	public function displayPage ($title = '',$id = '')
 	{
		if($id != '')
		{
			$q = " WHERE `id` = '".$id."' ";
		}
		else
		{
			$q = " WHERE `name` = '".$title."' ";
		}

		$query = $this->db->query(" SELECT * FROM `pages`  ".$q." ");
		$issetPage = $this->db->resultcount($query);

		if($issetPage != 0)
		{
			while($this->db->fetchrow($query))
			{
				$array[id] 			= $this->db->_record[id];
				$array[title] 		= $this->db->_record[title];
				$array[name]		= $this->db->_record[name];
				$array[content] 	= $this->db->_record[content];
				$array[totalview] 	= $this->db->_record[totalview];
				$array[allow_share] = $this->db->_record[allow_share];
			}


			$array[content] 	= stripslashes($array[content]);
			$array[content] 	= str_replace(array("\r\n", "\r", "\n", "\t"), ' ', $array[content]);
            $array[content] 	= str_replace("rn", ' ', $array[content]);

			$this->db->query(" UPDATE `pages` SET `totalview` = totalview+1 ".$q." ");

			return($array);
		}
		else
		{
          	return(false);
		}
 	}


 	public function doEditPage ($id,$name,$title ,$content, $share)
 	{

	      /* Name error checking */
	      $field = "name";
	      if(!$name || strlen($name = trim($name)) == 0)
	      {
	         $this->form->setError($field, $GLOBALS[lang][_pages_addpage_no_name]);
	      }

	      /* Title error checking */
	      $field = "title";
	      if(!$title || strlen($title = trim($title)) == 0)
	      {
	         $this->form->setError($field, $GLOBALS[lang][_pages_addpage_no_title]);
	      }

	      /* Content error checking */
	      $field = "content";
	      if(!$content || strlen($content = trim($content)) == 0)
	      {
	         $this->form->setError($field, $GLOBALS[lang][_pages_addpage_no_content]);
	      }

	      if($this->form->_num_errors > 0)
	      {
	         return false;  //Errors with form
	      }
	      else
	      {

	      	 $content = stripslashes($content);

	         if($this->doUpdatePage($id,$name ,$title ,$content, $share))
	         {
	            return true;
	         }
	         else
	         {
	            return false;
	         }

	      }
 	}

 	private function doUpdatePage ($id,$name ,$title ,$content, $share)
 	{
		$info = array("table"=>"pages",
			      	  "row" => "id" ,
					  "id" => $id);

    	$array = array(
    				"name"			=> $name,
		    		"title" 		=> $title,
		    		"content" 		=> $content,
		    		"allow_share" 	=> $share
		    		);

		$update = $this->db->update($info,$array);

		if($update)
		{
			return(true);
		}
		else
		{
			return(false);
		}
 	}


 	public function listPages()
 	{
		$query = $this->db->query(" SELECT * FROM `pages` LIMIT 0 , 100  ");
		$totalpages = $this->db->resultcount($query);

		if($totalpages != 0)
		{
			while($this->db->fetchrow($query))
			{
				$array[] = $this->db->_record;
			}
			return($array);
		}
		else
		{
			return(false);
		}
 	}

 	public function deletePage ($id)
 	{
		$del = $this->db->query(" DELETE FROM `pages` WHERE `id` = '".$id."' ");

		if($del)
		{
			return(true);
		}
		else
		{
			return(false);
		}

 	}



}


?>